/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageType;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class WorldMapMessageHandler {
    public static final int NETWORK_COMPATIBILITY = 2;
    private Map<Integer, WorldMapMessageType<?>> typeByIndex = new HashMap();
    private Map<Class<?>, WorldMapMessageType<?>> typeByClass = new HashMap();

    public <T extends WorldMapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<class_2540, T> decoder, BiConsumer<T, class_2540> encoder) {
        WorldMapMessageType<T> messageType = new WorldMapMessageType<T>(index, type, serverHandler, clientHandler, decoder, encoder);
        this.typeByIndex.put(index, messageType);
        this.typeByClass.put(type, messageType);
    }

    public WorldMapMessageType<?> getByIndex(int index) {
        return this.typeByIndex.get(index);
    }

    public WorldMapMessageType<?> getByClass(Class<?> clazz) {
        return this.typeByClass.get(clazz);
    }

    private class_2540 toBuffer(WorldMapMessage<?> message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        WorldMapMessageType<?> type = this.typeByClass.get(message.getClass());
        buf.writeByte(type.getIndex());
        this.toBufferHelper(type, message, buf);
        return buf;
    }

    private <T extends WorldMapMessage<T>> void toBufferHelper(WorldMapMessageType<T> type, WorldMapMessage<?> message, class_2540 buf) {
        WorldMapMessage<?> messageCast = message;
        type.getEncoder().accept(messageCast, buf);
    }

    public void sendToPlayer(class_3222 player, WorldMapMessage<?> message) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)WorldMapMessage.MAIN_CHANNEL, (class_2540)this.toBuffer(message));
    }

    public void sendToServer(WorldMapMessage<?> message) {
        ClientPlayNetworking.send((class_2960)WorldMapMessage.MAIN_CHANNEL, (class_2540)this.toBuffer(message));
    }
}

